<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van QUMT_IN020010 - Find Act Reference Registry Entries</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <!--pattern is-a="attentionLine" id="QUMT_IN020010-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value"/>
        <param name="attentionLineOptional" value="'false'"/>
        </pattern-->
    
    <pattern is-a="transmission-wrapper" id="QUMT_IN020010-wrapper">
        <param name="element" value="hl7:QUMT_IN020010"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="QUMT_IN020010-controlAct">
        <param name="element" value="hl7:QUMT_IN020010/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:QUMT_IN020010/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:QUMT_IN020010/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:QUMT_IN020010/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:QUMT_IN020010/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:QUMT_IN020010/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De ontvanger van deze interactie moet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>QueryByParameter</title>
        <rule context="hl7:queryByParameter">
            <assert role="error" test="hl7:actId or hl7:patientId"
                >Tenminste één van de parameters actId of patientId moet een waarde bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:responseModalityCode">
            <assert role="error" test="@code='R'"
                >hl7:responseModalityCode/@code moet "R" bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:actId/hl7:value">
            <extends rule="II"/>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:authorId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.528.1.1007.3.1'"
                >Het attribuut <value-of select="local-name(..)"/>/value/@root moet de waarde “2.16.528.1.1007.3.1” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:authorRoleCode/hl7:value">
            <extends rule="CD"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111'"
                >Het attribuut <value-of select="local-name(..)"/>/value/@codeSystem moet de waarde “2.16.840.1.113883.2.4.15.111” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:EffectiveTime/hl7:value">
            <extends rule="IVL_TS"/>
            <assert role="error" test="not(@value or hl7:width or hl7:center) and (hl7:low/@value or hl7:high/@value)"
                >Alleen periodes op basis van <value-of select="local-name(..)"/>/value/low/@value (ondergrens) en/of <value-of select="local-name(..)"/>/value/high/@value (bovengrens) zijn toegestaan</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:patientId">
            <assert role="error" test="count(hl7:value)=1"
                >Het is niet mogelijk om voor meer dan één patiënt gegevens op te vragen.</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:patientId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
                >Het attribuut <value-of select="local-name(..)"/>/value/@root moet de waarde “2.16.840.1.113883.2.4.6.3” bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:registrationprocessActCode/hl7:value">
            <extends rule="CD"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.4' or @codeSystem='2.16.840.1.113883.6.1'"
                >Het attribuut <value-of select="local-name(..)"/>/value/@codeSystem moet de waarde “2.16.840.1.113883.2.4.15.4” of “2.16.840.1.113883.6.1” bevatten</assert>
        </rule>
    </pattern>
</schema>